<?php
if ( !isset($_POST['selectionItemId']) ) {
    http_response_code(400);
    echo json_encode('No selection item ID');
    exit;
}

if ( !$selection = $db->row("SELECT * FROM selection_item WHERE id = ?", $_POST['selectionItemId']) ) {
    http_response_code(400);
    echo json_encode('Invalid selection item ID');
    exit;
}

if ( !$user['superAdmin'] ) {
    if ( !$exists = $db->cell("SELECT id FROM client_project WHERE clientId = ? AND projectId = ?", $user['client']['id'], $selection['projectId']) ) {
        http_response_code(403);
        echo json_encode('You do not have permission to edit this selection item');
        exit;
    }
}

$selection['tags'] = $db->run("SELECT tagId FROM selection_item_tag WHERE selectionItemId = ?", $selection['id']);

echo json_encode([
    'image' => $selection['image'],
    'title' => $selection['title'],
    'vendor' => $selection['vendor'],
    'description' => $selection['description'],
    'unit' => $selection['unit'],
    'cost' => $selection['cost'],
    'quantity' => $selection['quantity'],
    'link' => $selection['link'],
    'id' => $selection['id'],
    'tags' => $selection['tags']
]);

?>