<?php

if ( !isset($_GET['id']) ) {
    http_response_code(400);
    echo json_encode('No selection ID');
    exit;
} else {
    $selectionId = $_GET['id'];
    if ( !$selection = $db->row("SELECT * FROM selection_item WHERE id = ?", $selectionId) ) {
        http_response_code(400);
        echo json_encode('Selection not found');
        exit;
    }
}

//check if user is an admin. if not, check if they are assigned to this project
if ( !$user['admin'] ) {
    if ( !$exists = $db->cell("SELECT id FROM client_project WHERE clientId = ? AND projectId = ?", $user['client']['id'], $selection['projectId']) ) {
        http_response_code(403); //forbidden
        echo json_encode('You do not have permission to view this selection');
        exit;
    }
}

//load the rest of the selection data (comments, attachments, etc)
ob_start();
include '../template/selection.php';
$html = ob_get_clean();

echo json_encode([
    'title' => $selection['room'].' '.$selection['category'],
    'html' => $html,
]);
?>
