<div id="selectionsNewGroupModal" class="modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="newGroupsForm" method="POST" action="<?php echo URL_APP; ?>/selections/src/new-groups.php">




                <div class="modal-header">
                    <h5 id="selectionsNewGroupModalTitle" class="modal-title">New Group</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="selectionsNewGroupModalBody">


                    <ul class="nav nav-underline btbSelectionsToolbar mb-3" id="selectionNewGroupTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="manualGroupsTabHeading" data-bs-toggle="tab" data-bs-target="#manualGroupsTab" type="button" role="tab">
                                Manual<i class="bi bi-ui-checks ms-2"></i>
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="automaticGroupsTabHeading" data-bs-toggle="tab" data-bs-target="#automaticGroupsTab" type="button" role="tab">
                                Auto<i class="bi bi-magic ms-2"></i>
                            </button>
                        </li>
                    </ul>




                    <div class="tab-content" id="selectionGroupTabContent">


                        <div class="tab-pane fade show active" id="manualGroupsTab" role="tabpanel" tabindex="0">
                            <div class="d-flex align-items-center justify-content-between mb-1">
                                <h6>Custom</h6>
                                <a id="selectionNewManualGroup" class="btbAction p-0" type="button" data-action="click" data-target="new group" title="New group">
                                    <i class="bi bi-plus-circle text-danger"></i>
                                </a>
                            </div>
                            <div id="newManualGroupContainer" class="row align-items-center justify-content-center mb-3">
                                <div class="col-1">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="selectionCheck[0]" value="" checked>
                                    </div>
                                </div>
                                <div class="col-11">
                                    <input type="text" class="form-control mb-1" name="selectionText[0]" placeholder="Group name">
                                </div>
                            </div>
                            <h6>Categories</h6>
                            <div class="row mb-3">
                                <?php 
                                    foreach ( $defaultCategories as $category ) :
                                        $title = str_replace(' ', '-', $category['title']);
                                ?>
                                    <div class="col-12 col-md-6">
                                        <div>
                                            <input class="form-check-input" type="checkbox" value="<?php echo $title; ?>" id="groupDefault-<?php echo $title; ?>" name="selectionDefaultCheck[]">
                                            <label class="form-check-label" for="groupDefault-<?php echo $title; ?>">
                                                <span class="small"><?php echo $category['title']; ?></span>
                                            </label>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <h6>Rooms</h6>
                            <div class="row mb-1">
                                <?php 
                                    foreach ( $defaultRooms as $room ) :
                                        $title = str_replace(' ', '-', $room['title']);
                                ?>
                                    <div class="col-12 col-md-6">
                                        <div>
                                            <input class="form-check-input" type="checkbox" value="<?php echo $title; ?>" id="groupDefault-<?php echo $title; ?>" name="selectionDefaultCheck[]">
                                            <label class="form-check-label" for="groupDefault-<?php echo $title; ?>">
                                                <span class="small"><?php echo $room['title']; ?></span>
                                            </label>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>


                        <div class="tab-pane fade" id="automaticGroupsTab" role="tabpanel" tabindex="0">
                            <div id="automaticGroupsUploadArea">
                                <h6 class="mb-0">Automatic Groups</h6>
                                <span class="small text-muted mb-4">Upload a plan PDF to have groups created automatically based on the rooms shown in the plans.</span>
                                <input type="hidden" id="newSelectionSheetProjectId" value="<?php echo $pid; ?>">
                                <div id="selectionsDropzone" class="d-flex justify-content-center align-items-center rounded overflow-x-scroll" style="border:1px grey dashed;min-height:200px;cursor:pointer;">
                                    <div id="addPlans" class="text-center">
                                        <div class="fw-bold">Add Plan(s)</div>
                                    </div>
                                </div>
                                <div class="small mt-1 ms-1">
                                    <span class="text-muted">Drag and drop or click inside the box to upload files</span>
                                    <br> 
                                    <span class="text-muted">Max number of files:</span> 1
                                    <br>
                                    <span class="text-muted">Max size per file:</span> 30MB
                                    <br>
                                    <span class="text-muted">Max total upload size:</span> 30MB 
                                    <br>
                                    <span class="text-muted">Accepted file types:</span> PDF
                                </div>
                            </div>


                            <div id="automaticGroupsResult">
                            </div>
                        </div>


                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button id="newGroupsSubmit" type="submit" class="btn btn-danger">Save</button>
                </div>
                <input type="hidden" name="projectId" value="<?php echo $pid; ?>">
            </form>
        </div>
    </div>
</div>  