<div id="newSelectionItemModal" class="modal" tabindex="-1">
    <div class="modal-dialog">
        <form id="newSelectionItemForm" action="<?php echo URL_APP; ?>/selections/src/new-selection-item.php" method="POST">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 id="newSelectionItemModalTitle" class="modal-title">New Selection Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="newSelectionItemModalBody">
                    <h6 class="mb-0">Automatic</h6>
                    <p class="small text-muted mb-2">
                        Paste the URL of a product for an automatic form fill.
                    </p>
                    <div class="input-group">
                        <input id="newAutomaticSelectionItemUrl" type="text" class="form-control" placeholder="https://www.example-vendor.com/product/some-product-url/">
                        <button id="newAutomaticSelectionItemButton" class="btn btn-outline-danger" type="button">
                            Go
                            <i class="bi bi-magic"></i>
                        </button>
                    </div>
                    <hr>
                    <div id="selectionItemResult">
                        <div id="selectionItemDropzoneContainer" class="mb-2">
                            <div id="selectionItemDropzone" class="d-flex justify-content-center align-items-center rounded overflow-x-scroll" style="border:1px grey dashed;min-height:200px;cursor:pointer;">
                                <div id="uploadSelectionImage" class="text-center">
                                    <div class="fw-bold">Add Image</div>
                                </div>
                            </div>
                            <div class="small mt-1 ms-1">
                                <span class="text-muted">Drag and drop or click inside the box to upload files</span>
                                <br> 
                                <span class="text-muted">Max number of files:</span> 1
                                <br>
                                <span class="text-muted">Max size per file:</span> 30MB
                                <br>
                                <span class="text-muted">Max total upload size:</span> 30MB 
                                <br>
                                <span class="text-muted">Accepted file types:</span> JPG/JPEG, PNG
                            </div>
                        </div>

                        <div id="newAutomaticSelectionItemImageContainer" class="mb-2 d-none">
                            <div class="d-flex justify-content-between px-2 pb-1">
                                <span class="small text-muted">Image</span>
                                <button id="removeSelectionItemImageButton" type="button" class="btn-close" data-bs-toggle="tooltip" data-bs-title="Remove image"></button>
                            </div>
                            <img id="newAutomaticSelectionItemImage" class="img-thumbnail" src="">
                        </div>

                        <div class="form-floating mb-2">
                            <input id="selectionItemTitle" type="text" name="title" class="form-control" minlength="3" required>
                            <label for="name">Title</label>
                        </div>
                        <div class="form-floating mb-2">
                            <input id="selectionItemVendor" type="text" name="vendor" class="form-control" minlength="3" required>
                            <label for="name">Vendor</label>
                        </div>
                        <div class="form-floating mb-2">
                            <textarea id="selectionItemDescription" name="description" class="form-control" style="height:200px;"></textarea>
                            <label for="description">Description</label>
                        </div>
                        <div class="mb-2">
                            <select id="selectionItemTags" name="tags[]" class="selectpicker my-1" multiple data-live-search="true" title="Select tag(s)" data-selected-text-format="count > 2" data-width="100%">
                                <?php foreach ( $defaultCategories as $category ) : ?>
                                    <option value="<?php echo $category['id']; ?>"><?php echo $category['title']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-floating mb-2">
                            <input id="selectionItemUnit" type="text" name="unit" class="form-control">
                            <label for="unit">Unit</label>
                        </div>
                        <div class="input-group mb-2">
                            <label class="input-group-text"><i class="bi bi-currency-dollar text-success"></i></label>
                            <div class="form-floating">
                                <input id="selectionItemCost" type="text" name="cost" step=".01" class="form-control">
                                <label for="cost">Cost Per Unit</label>
                            </div>
                        </div>
                        <div class="form-floating mb-2">
                            <input id="selectionItemQuantity" type="text" name="quantity" class="form-control">
                            <label for="quantity">Quantity</label>
                        </div>
                        <div class="form-floating mb-2">
                            <input id="selectionItemLink" type="text" name="link" class="form-control">
                            <label for="link">Link</label>
                        </div>

                        <input id="selectionItemProjectId" type="hidden" name="projectId" value="<?php echo $pid; ?>">
                        <input id="selectionItemGroupId" type="hidden" name="groupId" value="">
                        <input id="selectionItemImageUrl" type="hidden" name="selectionItemImageUrl" value="">

                    </div>
                </div>
                <div id="newSelectionItemModalFooter" class="modal-footer">
                    <button id="resetNewSelectionItemFormButton" type="submit" class="btn btn-warning me-auto">Reset</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button id="saveNewSelectionItemButton" type="submit" class="btn btn-danger">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>  