<?php if ( $numSelectionItems && $totalCost ) : ?>
<div class="d-flex align-items-center justify-content-between mx-2 mb-2">
    <span class="small text-muted"><?php echo count($groups); ?> groups, <?php echo $numSelectionItems; ?> items</span>
    <div class="small text-success fw-bold">$<?php echo number_format($totalCost, 2); ?></div>
</div>
<?php endif; ?>
<?php
    foreach ( $groups as $group ) :
        $count = ( count($group['selections']) > 0 )
            ? count($group['selections']).' items'
            : '0 items'
        ;
        $cost = '$'.number_format($group['cost'], 2);
?>
<!-- <pre><?php //print_r($group); ?></pre> -->
    <div class="card bg-light-subtle shadow selectionGroup mb-3" data-id="<?php echo $group['id']; ?>">
        <div class="card-header sticky-top bg-light-subtle shadow-sm" style="z-index:999 !important;">
            <div class="d-flex justify-content-between align-items-center">
                <div class="hstack gap-2" style="min-width:0;">
                    <div class="fs-4 selectionGroupHandle" style="cursor:grab;">
                        <i class="bi bi-grip-vertical"></i>
                    </div>
                    <!-- <div> -->
                        <div class="fw-bold text-truncate" data-bs-toggle="tooltip" data-bs-title="<?php echo htmlspecialchars($group['title']); ?>">
                            <?php echo htmlspecialchars($group['title']); ?>
                        </div>
                    <!-- </div> -->
                </div>
                <!-- <i class="bi bi-pencil-fill ms-auto me-1"></i> -->
                <!-- <button class="btn btn-sm btn-danger btbAction" type="button" data-action="click" data-target="new group" data-bs-toggle="modal" data-bs-target="#selectionsNewGroupModal" title="New group">
                    <i class="bi bi-plus"></i>
                </button> -->
                <div class="dropdown dropdownSelectionGroup">
                    <i class="bi bi-three-dots-vertical fs-4" data-bs-toggle="dropdown" role="button"></i>
                    <ul class="dropdown-menu">
                        <li><a data-group="<?php echo $group['id']; ?>" class="dropdown-item newSelectionItemButton" role="button" data-action="click" data-target="new selection item" data-bs-toggle="modal" data-bs-target="#newSelectionItemModal" title="New selection item">New selection item</a></li>
                        <li><a data-group="<?php echo $group['id']; ?>" class="dropdown-item editSelectionGroupButton" role="button" data-action="click" data-target="edit selection group" data-bs-toggle="modal" data-bs-target="#editGroupModal" title="Edit selection group">Edit group</a></li>
                        <li><a data-group="<?php echo $group['id']; ?>" class="dropdown-item viewSelectionGroupFinishScheduleButton" role="button" data-action="click" data-target="view selection group finish schedule" data-bs-toggle="modal" data-bs-target="#generatePdfModal" title="View group finish schedule">View group finish schedule</a></li>
                        <?php if ( $user['superAdmin'] ) : ?>
                            <li><a class="dropdown-item" href="<?php echo URL_APP; ?>/selections/src/delete-group.php?groupId=<?php echo $group['id']; ?>" onclick="return confirm('Are you absolutely sure you want to delete this group? THIS WILL DELETE THE GROUP AND ALL SELECTION ITEMS WITHIN. This cannot be undone.')">Delete group</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <div class="d-flex align-items-center">
                <!-- <div> -->
                    <div class="small text-muted"><?php echo $count; ?></div>
                    <span class="small text-muted">&nbsp;-&nbsp;</span>
                    <div class="small text-success fw-bold"><?php echo $cost; ?></div>
                <!-- </div> -->
                <div class="fs-4 selectionGroupCollapseToggle text-end ms-auto" role="button" data-bs-toggle="collapse" data-bs-target="#selection-group-collapse-<?php echo $group['id']; ?>" aria-expanded="true">
                    <i class="bi bi-chevron-up"></i>
                </div>
            </div>
        </div>
        <div id="selection-group-collapse-<?php echo $group['id']; ?>" class="collapse show selectionGroupCollapse" data-id="<?php echo $group['id']; ?>">
            <div class="card-body">
                <div class="small mb-2">
                    <span class="fw-bold">Group description: </span><span class="text-muted fst-italic"><?php echo nl2br(htmlspecialchars($group['description'])) ?? 'No description'; ?></span>
                </div>
                
                <div id="selection-group-<?php echo $group['id']; ?>" class="selectionItemsList" data-id="<?php echo $group['id']; ?>">
                    <?php foreach ( $group['selections'] as $selection ) : ?>
                        <?php include 'selection-item.php'; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; ?>