<div class="card rounded-4 mb-1" data-id="<?php echo $selection['id']; ?>">
    <div class="card-body">
        <div class="text-end">
            <input class="form-check-input form-check-input-lg mb-2 selectionItemCheck selectionItemCheck-group-<?php echo $group['id']; ?>" type="checkbox" data-selection-item-id="<?php echo $selection['id']; ?>" data-group-id="<?php echo $group['id']; ?>">
        </div>
        <!-- <div class="hstack gap-1 align-items-center justify-content-between mb-1"> -->
        <div class="hstack gap-1 align-items-center overflow-y-scroll mb-1">
            <!-- <input class="form-check-input form-check-input-lg" type="checkbox"> -->
            <!-- <div> -->
            <?php foreach ( $selection['tags'] as $tag ) : ?>
                <span class="badge rounded-pill text-bg-danger editSelectionItemButton selectionItem-<?php echo $selection['groupId']; ?>" data-id="<?php echo $selection['id']; ?>" role="button" data-action="click" data-target="edit selection item" data-bs-toggle="modal" data-bs-target="#editSelectionItemModal" title="Edit selection item">
                    <?php echo $tag['title']; ?>
                </span>
            <?php endforeach; ?>
            <!-- </div> -->
            <!-- <span class="badge rounded-pill border border-dashed"><i class="bi bi-plus" style="color:var(--bs-border-color);"></i></span> -->
        </div>
        <div class="d-flex align-items-center">
            <div class="fs-4 me-2 selectionItemHandle" style="cursor:grab;">
                <i class="bi bi-grip-vertical"></i>
            </div>
            <div class="editSelectionItemButton selectionItem-<?php echo $selection['groupId']; ?>" data-id="<?php echo $selection['id']; ?>" role="button" data-action="click" data-target="edit selection item" data-bs-toggle="modal" data-bs-target="#editSelectionItemModal" title="Edit selection item">
            <?php if ( $selection['image'] ) : ?>
                <img class="rounded-4 shadow me-2" src="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo htmlspecialchars($selection['image']); ?>" alt="<?php echo htmlspecialchars($selection['title']); ?>" title="<?php echo htmlspecialchars($selection['title']); ?>" style="width:80px;height:80px;object-fit:cover;">
            <?php else : ?>
                <img class="rounded-4 shadow me-2" src="<?php echo URL_ASSETS; ?>/images/btb-logo-abbr-trans.png" alt="No selection image" title="No selection image" style="width:80px;height:80px;object-fit:cover;">
            <?php endif; ?>
            </div>
            <div>
                <?php
                    $titleSm = ( strlen($selection['title']) > 100 )
                        ? substr($selection['title'], 0, 100).' ...'
                        : $selection['title']
                    ;
                    $titleLg = ( strlen($selection['title']) > 150 )
                        ? substr($selection['title'], 0, 150).' ...'
                        : $selection['title']
                    ;
                ?>
                <div class="fw-bold editSelectionItemButton selectionItem-<?php echo $selection['groupId']; ?> d-lg-none" data-id="<?php echo $selection['id']; ?>" role="button" data-action="click" data-target="edit selection item" data-bs-toggle="modal" data-bs-target="#editSelectionItemModal" title="Edit selection item">
                    <?php echo htmlspecialchars($titleSm); ?>
                </div>
                <div class="fw-bold editSelectionItemButton selectionItem-<?php echo $selection['groupId']; ?> d-none d-lg-flex" data-id="<?php echo $selection['id']; ?>" role="button" data-action="click" data-target="edit selection item" data-bs-toggle="modal" data-bs-target="#editSelectionItemModal" title="Edit selection item">
                    <?php echo htmlspecialchars($titleLg); ?>
                </div>
                <div class="small text-muted"><?php echo htmlspecialchars($selection['vendor']); ?></div>
                <?php 
                    if ( is_numeric($selection['cost']) && is_numeric($selection['quantity']) ) :
                        $selectionTotal = $selection['cost'] * $selection['quantity'];
                ?>
                        <span class="text-success"><?php echo '$'.number_format($selectionTotal, 2); ?></span>
                        <div class="small">
                            <span class="text-muted"> (<?php echo htmlspecialchars($selection['quantity']); ?> @ $<?php echo number_format(htmlspecialchars($selection['cost']), 2); ?> / <?php echo htmlspecialchars($selection['unit']); ?>)</span>
                        </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>