<table id="selectionsDT" class="table table-striped table-bordered table-hover table-sm border-top border-bottom responsive w-100">
    <thead>
        <tr class="text-center">
            <th scope="col">#</th>
            <th scope="col" class="all">Selection</th>
            <th scope="col">Category</th>
            <th scope="col">Room</th>
            <th scope="col">Level</th>
            <th scope="col">Type</th>
            <th scope="col">Status</th>
            <th scope="col">Image</th>
            <th scope="col">Link</th>
        </tr>
    </thead>
    <tbody>
    <?php
        $i = 0;
        foreach ( $projectSelections as $projectSelection ) :
            foreach ( $projectSelection as $key => $value ) {
                switch ( $key ) {
                    case 'link' :
                    case 'roomImage' :
                    case 'selectionImage' :
                        break;
                    default :
                        // $projectSelections[$i][$key] = ( strlen($value) > 25 )
                        //     ? substr($value, 0, 40) . ' ...'
                        //     : $value
                        // ;
                }
            }

            if ( $projectSelections[$i]['selected'] ) {
                $status = '<i class="bi bi-check text-success" data-bs-toggle="tooltip" data-bs-title="Selected"></i>';
                $hidden = 'Selected';
            } elseif ( $projectSelections[$i]['priority'] ) {
                $status = '<i class="bi bi-flag-fill text-warning" data-bs-toggle="tooltip" data-bs-title="Priority - Select ASAP"></i>';
                $hidden = 'Priority';
            } elseif ( $projectSelections[$i]['na'] ) {
                $status = 'N/A';
                $hidden = 'N/A';
            } else {
                $status = '';
                $hidden = 'No Selection';
            }

            if ( $projectSelections[$i]['selectionImage'] ) {
                $baseSrc  = URL_SELECTION_ATTACHMENTS;
                $basePath = PATH_SELECTION_ATTACHMENTS;
    
                $link = "$baseSrc/".$projectSelections[$i]['selectionImage'];
                $dl   = $link;
                $src  = $link;
                if ( file_exists("$basePath/small/$projectSelections[$i][selectionImage]") ) {
                    $link = "$baseSrc/small/$projectSelections[$i][selectionImage]";
                    $src  = $link;
                }
                if ( file_exists("$basePath/thumbs/$projectSelections[$i][selectionImage]") ) {
                    $src = "$baseSrc/thumbs/$projectSelections[$i][selectionImage]";
                }
            } else {
                $link = URL_ASSETS.'/images/no-selection.png';
                $dl   = $link;
                $src  = $link;
            }
    ?>
        <tr class="text-center">
            <td width="5%" style="white-space:nowrap;"><?php echo $i + 1; ?></td>
            <td width="15%" style="white-space:nowrap;text-align:left;">
                <?php if ( $projectSelections[$i]['selected'] ) : ?>
                    <a href=""  data-bs-toggle="modal" data-bs-target="#selectionsModal" data-id="<?php echo $projectSelections[$i]['id']; ?>" class="d-inline-block text-danger text-truncate fw-bold selection" style="max-width:250px;">
                        <?php echo $projectSelections[$i]['title']; ?>
                    </a>
                <?php else : ?>
                    <?php echo $projectSelections[$i]['title']; ?>
                <?php endif; ?>
            </td>
            <td width="10%" style="white-space:nowrap;"><?php echo $projectSelections[$i]['category']; ?></td>
            <td width="10%" style="white-space:nowrap;">
                <a href="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo $projectSelections[$i]['roomImage']; ?>" data-fancybox="btb-selection-rooms-<?php echo $i; ?>" data-download-src="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo $projectSelections[$i]['roomImage']; ?>" class="text-danger icon-link icon-link-hover link-underline-danger d-inline">
                    <?php echo $projectSelections[$i]['room']; ?>
                    <i class="bi bi-card-image"></i>
                </a>
            </td>
            <td width="8%" style="white-space:nowrap;"><?php echo $projectSelections[$i]['level']; ?></td>
            <td width="8%" style="white-space:nowrap;"><?php echo $projectSelections[$i]['type']; ?></td>
            <td width="8%" style="white-space:nowrap;text-align:center;">
                <span class="visually-hidden"><?php echo $hidden; ?></span>
                <?php echo $status; ?>
            </td>
            <td width="50px" height="50px" style="white-space:nowrap;padding:0;">
                <a href="" class="selection" data-bs-toggle="modal" data-bs-target="#selectionsModal" data-id="<?php echo $projectSelections[$i]['id']; ?>">
                    <img 
                        data-src="<?php echo $src; ?>" 
                        alt="<?php echo $userProject['title'] ?>" 
                        class="lazy object-fit-cover"
                        style="/*width:50px;height:50px;*/width:100%;height:100%;display:block;"
                    >
                </a>
            </td>
            <td width="8%" style="white-space:nowrap;">
                <?php if ( $projectSelections[$i]['link'] ) : ?>
                <a href="<?php echo $projectSelections[$i]['link']; ?>" target="_blank" class="text-danger icon-link icon-link-hover link-underline-danger d-inline">
                    <?php echo $projectSelections[$i]['vendor']; ?>
                    <i class="bi bi-arrow-up-right small"></i>
                </a>
                <?php else : ?>
                    <?php echo $projectSelections[$i]['vendor']; ?>
                <?php endif; ?>
            </td>
        </tr>
    <?php 
            $i++;
        endforeach;
    ?>
    </tbody>
</table>