<?php
    if ( isset($_COOKIE['btbFilters']) ) {
        parse_str($_COOKIE['btbFilters'], $filters);
        // echo "<pre>".print_r($filters)."</pre>";
    } else {
        $checked = true;
    }

    $allow = ( $user['superAdmin'] || $user['admin'] || $user['client']['social'] )
        ? true
        : false
    ;
?>
<li class="dropdown-item bg-secondary-subtle shadow-sm d-flex align-items-center <?php if ( $allow ) : ?>justify-content-between<?php else : ?>justify-content-start<?php endif; ?> sticky-top overflow-x-scroll py-2">
    <?php if ( $allow ) : ?>
        <div class="form-check form-check-inline m-0">
            <input class="form-check-input notifFilter" type="checkbox" id="likeFilterCheck" value="like" name="likeFilter" <?php if ( $filters['like'] || $checked ) : ?>checked="checked"<?php endif; ?> data-filter="likeFilter">
            <label class="form-check-label small text-muted <?php if ( !$filters['like'] && $blink && in_array('thumb', $objectTypes) ) : ?>blink<?php endif; ?>" for="likeFilterCheck">Likes</label>
        </div>
    <?php endif; ?>
    <div class="form-check form-check-inline m-0">
        <input class="form-check-input notifFilter" type="checkbox" id="commentFilterCheck" value="comment" name="commentFilter" <?php if ( $filters['comment'] || $checked ) : ?>checked="checked"<?php endif; ?> data-filter="commentFilter">
        <label class="form-check-label small text-muted <?php if ( !$allow ) : ?>me-3<?php endif; ?> <?php if ( !$filters['comment'] && $blink && in_array('comment', $objectTypes) ) : ?>blink<?php endif; ?>" for="commentFilterCheck">Posts</label>
    </div>
    <?php if ( $allow ) : ?>
        <div class="form-check form-check-inline m-0">
            <input class="form-check-input notifFilter" type="checkbox" id="replyFilterCheck" value="reply" name="replyFilter" <?php if ( $filters['reply'] || $checked ) : ?>checked="checked"<?php endif; ?> data-filter="replyFilter">
            <label class="form-check-label small text-muted <?php if ( !$filters['reply'] && $blink && in_array('reply', $objectTypes) ) : ?>blink<?php endif; ?>" for="replyFilterCheck">Replies</label>
        </div>
    <?php endif; ?>
    <div class="form-check form-check-inline m-0">
        <input class="form-check-input notifFilter" type="checkbox" id="taskFilterCheck" value="task" name="taskFilter" <?php if ( $filters['task'] || $checked ) : ?>checked="checked"<?php endif; ?> data-filter="taskFilter">
        <label class="form-check-label small text-muted <?php if ( !$allow ) : ?>me-3<?php endif; ?> <?php if ( !$filters['task'] && $blink && in_array('task', $objectTypes) ) : ?>blink<?php endif; ?>" for="taskFilterCheck">Tasks</label>
    </div>
    <?php if ( $user['superAdmin'] ) : ?>
        <div class="form-check form-check-inline m-0">
            <input class="form-check-input notifFilter" type="checkbox" id="visitFilterCheck" value="visit" name="visitFilter" <?php if ( $filters['visit'] || $checked ) : ?>checked="checked"<?php endif; ?> data-filter="visitFilter">
            <label class="form-check-label small text-muted <?php if ( !$filters['visit'] && $blink && in_array('visit', $objectTypes) ) : ?>blink<?php endif; ?>" for="visitFilterCheck">Visits</label>
        </div>
    <?php endif; ?>
</li>